import React, { useState } from 'react';
import { AppStateProvider } from './Context.js';
import { Tab, TabList, TabPanel, Tabs } from 'react-tabs';
import Keywords from './pages/Keywords.js';
import Competitors from './pages/Competitors.js';
import Guidance from './pages/Guidance.js';
import ContentOutline from './pages/ContentOutline.js';
import Footer from './components/Footer.js';
import './App.css';

function AppInner() {
  const [tabIndex, setTabIndex] = useState(0);

  return (
    <Tabs className="conductor" selectedIndex={tabIndex} onSelect={(index) => setTabIndex(index)}>
      <TabList className="conductor__tab-list">
        <Tab className="conductor__tab">Keywords</Tab>
        <Tab className="conductor__tab">Competitors</Tab>
        <Tab className="conductor__tab">Guidance</Tab>
        <Tab className="conductor__tab">Content outline</Tab>
      </TabList>
      <TabPanel className="conductor__tab-panel">
        <Keywords setTab={(index: number) => setTabIndex(index)} nextTab={1} />
      </TabPanel>
      <TabPanel className="conductor__tab-panel">
        <Competitors setTab={(index: number) => setTabIndex(index)} nextTab={2} />
      </TabPanel>
      <TabPanel className="conductor__tab-panel">
        <Guidance />
      </TabPanel>
      <TabPanel className="conductor__tab-panel">
        <ContentOutline />
      </TabPanel>
      <Footer />
    </Tabs>
  );
}

function App() {
  const accountId = window?.drupalSettings?.conductor?.accountId ?? '';
  const draftId = window?.drupalSettings?.conductor?.draftId ?? '';
  let entityId = window?.drupalSettings?.canvas?.entity ?? '';
  let entityType = window?.drupalSettings?.canvas?.entityType ?? '';
  if (
    ('' === entityType || '' === entityId) &&
    window.location.pathname.startsWith('/canvas/editor/')
  ) {
    const parts = window.location.pathname.split('/').filter(Boolean);
    // The parameter is `/canvas/editor/{entity_type}/{entity_id}
    entityId = parts.pop() ?? '';
    entityType = parts.pop() ?? '';
  }

  if (!accountId) {
    return 'No conductor account ID found.';
  }
  return (
    <AppStateProvider
      initialState={{
        accountId,
        draft: { id: draftId },
        drupal: { entity: { type: entityType, id: entityId } },
      }}
    >
      <AppInner />
    </AppStateProvider>
  );
}

export default App;
