import React from 'react';
import { Circle, CircleX, CircleCheck } from 'lucide-react';
import './FormIndicator.css';

export default function FormIndicator({
  value,
  valid,
}: {
  value: boolean | string;
  valid: boolean;
}) {
  const getCircle = () => {
    if (typeof value === 'string' && value.length === 0) {
      return <Circle />;
    }

    if (valid) {
      return <CircleCheck />;
    }

    return <CircleX />;
  };

  return <div className="form-indicator">{getCircle()}</div>;
}
