import React, { type MouseEventHandler } from 'react';
import { X } from 'lucide-react';
import './Tag.css';

function Tag({
  children,
  remove,
}: {
  children: string;
  remove?: MouseEventHandler<HTMLButtonElement>;
}) {
  return (
    <span className="conductor__tag">
      {children}
      {remove && (
        <button
          onClick={remove}
          className="conductor__tag-remove"
          type="button"
          aria-label={`Remove ${children}`}
        >
          <X />
        </button>
      )}
    </span>
  );
}

export default Tag;
