import { render } from '@testing-library/react';
import ContentOutline from './ContentOutline.js';
import { AppStateProvider } from '../Context.js';
import { vi } from 'vitest';

vi.mock('../../assets/lightbulb.svg?react', () => ({
  default: () => <div data-testid="lightbulb-icon">Lightbulb</div>,
}));

const exampleDraftId = '9afb8bd1-97a0';

describe('Content Outline', () => {
  test('Canvas Page ID and Draft ID are rendered', async () => {
    const initialState = {
      accountId: '12345',
      canvasPageId: '1',
      draftId: exampleDraftId,
      keywords: ['rubik'],
      competitorUrls: [],
      excludedCompetitorUrls: [],
    };

    render(
      <AppStateProvider initialState={initialState}>
        <ContentOutline />
      </AppStateProvider>,
    );

    //const heading = screen.getByRole('heading', { level: 2, name: 'Content outline' });
    //expect(heading).toBeVisible();

    //// @todo change to the proper text when ready.
    //await waitFor(() => {
    //  expect(screen.queryByText('Draft ID: ' + exampleDraftId)).toBeInTheDocument();
    //});
  });
});
