import React from 'react';
import './ContentOutline.css';
import CreateTitle from '../components/CreateTitle.js';
import {
  useAccountId,
  useCompetitorUrls,
  useKeywords,
  useRankSource,
  useExcludedCompetitorUrls,
  useDraft,
} from '../Context.js';
import { post } from '../utilities/fetcher.js';
import useSWRImmutable from 'swr/immutable';

const ContentOutline = ({}: { setTab?: (index: number) => void; nextTab?: number }) => {
  const accountId = useAccountId();
  const rankSource = useRankSource();
  const keywords = useKeywords();
  const competitorUrls = useCompetitorUrls();
  const excludedCompetitorUrls = useExcludedCompetitorUrls();
  const draft = useDraft();

  // Create a new draft.
  useSWRImmutable(
    draft.id
      ? null
      : [
          `/conductor/proxy/v3/accounts/${accountId}/drafts/writing-assistant`,
          {
            draftTitle: draft.title,
            phrases: keywords,
            competitorUrls: competitorUrls.filter((url) => !excludedCompetitorUrls.includes(url)),
            rankSourceId: rankSource.id,
          },
        ],
    post,
  );

  return (
    <div className="content-outline">
      <CreateTitle />
    </div>
  );
};

export default ContentOutline;
