import tailwindcss from '@tailwindcss/vite';
import react from '@vitejs/plugin-react';
import { defineConfig } from 'vite';
import svgr from 'vite-plugin-svgr';

// https://vite.dev/config/
export default defineConfig({
  plugins: [react(), tailwindcss(), svgr()],
  define: {
    'process.env.NODE_ENV': JSON.stringify(process.env.NODE_ENV || 'production'),
  },
  build: {
    // @todo When this is bundled with the module it should be set to false.
    sourcemap: true,
    cssCodeSplit: false,
    lib: {
      entry: 'src/index.jsx',
      name: 'Conductor',
    },
    rollupOptions: {
      external: ['react', 'react-dom', '@redux/toolkit', 'react-redux'],
      output: {
        entryFileNames: `assets/[name].js`,
        chunkFileNames: `assets/[name].js`,
        assetFileNames: `assets/[name].[ext]`,
        globals: {
          react: 'React',
          'react-dom': 'ReactDom',
          '@reduxjs/toolkit': 'ReduxToolkit',
          'react-redux': 'Redux',
        },
      },
    },
  },
});
