# Development and testing

Ensure that the module's dependencies are correctly installed. From the root directory of your
Drupal installation, where the root `composer.json` is located, add the module (altering the path
`modules/contrib/conductor` as appropriate):

````shell
`modules/contrib/conductor` as appropriate):

```shell
composer config repositories.drupal/conductor --json '{"type": "path", "url": "modules/contrib/conductor" }'
composer require "drupal/conductor @dev" --with-all-dependencies
````

Then, from the module directory (not the Drupal root), add the module's dev dependencies:

```
cd modules/contrib/conductor
composer run install-dev-deps
npm install
```

If you are using a composer scaffolded copy of Drupal (i.e. not the core git checkout), then install
the `drupal/core-dev` package.

```shell
composer require drupal/core-dev --dev --with-all-dependencies
```

All the following composer and npm commands are run from the module directory.

## Linting

You can run all the following linting scripts in one go:

```shell
composer run lint && npm run lint
```

A lot of issues can be autofixed:

```
npm run autofix
```

### PHP_CodeSniffer

Also known as [`phpcs`](https://github.com/squizlabs/PHP_CodeSniffer), this script will detect
violations of a defined coding standard.

```shell
composer run phpcs
```

Violations, where possible, can be fixed with `phpcbf` (PHP Code Beautifier and Fixer).

```shell
composer run phpcbf
```

### PHPStan

PHPStan performs static analysis of code to detects potential errors.

```shell
composer run phpstan
```

Configuration is located in [`phpstan.neon`](../../phpstan.neon)

### eslint

This script will detect violations of a defined coding standard and perform static analysis of code.

```shell
npm run lint:eslint
```

Configuration is located in [`eslint.config.mjs`](../../eslint.config.mjs).

### prettier

A code formatter to enforce coding style across the project.

```shell
npm run lint:prettier
```

Configuration is located in [`.prettierrc.json`](../../.prettierrc.json) and
[`.prettierignore`](../../.prettierignore).

You can autofix with:

```
npm run lint:prettier -- --write
```

### tsc

Runs TypeScript checks.

```shell
npm run lint:tsc
```

Configuration is located in [`phpcs.xml`](../../phpcs.xml).

## Testing

### PHPUnit

PHPUnit runs both pure unit tests and tests which require a Drupal site (e.g. Kernel and
FunctionalJavascript).

Ensure that you first have a browser and companion webdriver installed (e.g. chromium/chrome and
chromedriver, or firefox and geckodriver). If you are not using chromedriver, or are running a
webserver other than DDEV or something accessible through `http://localhost`, then copy
`.env.defaults` to `.env` and edit as appropriate.

```shell
composer run phpunit
```

### Playwright

[Playwright](https://playwright.dev/) provides cross-browser functional testing.

```
npm run test:playwright
```

When running this test, it will use the bundled version of the application so ensure that
`npm run build` has been run against the latest code to be tested.

### vitest

Used with React Testing Library to test the extension application rendering.

```
npm test -w app
```
