<?php

declare(strict_types=1);

namespace Drupal\conductor\Controller;

use Drupal\conductor\ConductorHttpApiClient;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;

/**
 * Controller for proxying Conductor API calls.
 */
final readonly class ConductorProxyController implements ContainerInjectionInterface {

  public function __construct(private ConductorHttpApiClient $conductorHttpApiClient) {}

  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get(ConductorHttpApiClient::class)
    );
  }

  /**
   * Catch-all proxy endpoint for /conductor/proxy.
   */
  public function proxy(Request $request): Response {
    // @see \Drupal\conductor\ConductorPathProcessor
    $resource = $request->query->get('resource');
    \assert(is_string($resource));
    return $this->conductorHttpApiClient->forward($resource, $request);
  }

}
