<?php

declare(strict_types=1);

namespace Drupal\conductor\PathProcessor;

use Drupal\Core\PathProcessor\InboundPathProcessorInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Defines a path processor to rewrite file URLs.
 *
 * As the route system does not allow arbitrary amount of parameters convert
 * the file path to a query parameter on the request.
 */
class ConductorPathProcessor implements InboundPathProcessorInterface {

  /**
   * {@inheritdoc}
   */
  public function processInbound($path, Request $request) {
    if (str_starts_with($path, '/conductor/proxy') && !$request->query->has('resource')) {
      $conductor_resource = preg_replace('|^\/conductor\/proxy\/|', '', $path);
      $request->query->set('resource', $conductor_resource);
      return '/conductor/proxy';
    }
    return $path;
  }

}
