<?php

declare(strict_types=1);

namespace Drupal\Tests\conductor\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Tests basic JavaScript functionality.
 */
class ExampleFunctionalJavascriptTest extends WebDriverTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var string[]
   */
  protected static $modules = ['node', 'user'];

  /**
   * Tests basic JavaScript functionality.
   */
  public function testBasicJavaScript(): void {
    // Visit any page - no login needed for this basic test.
    $this->drupalGet('<front>');

    // Test that JavaScript is working by executing some basic JS.
    $result = $this->getSession()->evaluateScript('return 2 + 2;');
    $this->assertEquals(4, $result);

    // Test DOM manipulation with JavaScript.
    $this->getSession()->executeScript('
      var testDiv = document.createElement("div");
      testDiv.id = "js-test-element";
      testDiv.textContent = "JavaScript is working!";
      document.body.appendChild(testDiv);
    ');

    // Wait for the element to appear and verify it exists.
    $this->assertSession()->waitForElement('css', '#js-test-element');
    $this->assertSession()->elementTextContains('css', '#js-test-element', 'JavaScript is working!');
  }

}
