<?php

declare(strict_types=1);

namespace Drupal\Tests\conductor\Trait;

use Drupal\key\Entity\Key;

trait KeyTrait {

  public function generateKey(?string $name = 'conductor_test_key', ?string $label = 'Conductor Test Key'): void {

    $values = [
      'id' => $name,
      'label' => $label,
      'description' => 'Key for testing Conductor module',
      'key_type' => 'authentication',
      'key_provider' => 'config',
      'key_input' => 'text_field',
      'key_input_settings' => [],
      'key_provider_settings' => [
        'key_value' => json_encode([
          'api_key' => 'test_api_key',
          'shared_secret' => 'test_secret',
        ]),
      ],
    ];
    Key::create($values)->save();

    $config = \Drupal::configFactory()->getEditable('conductor.settings');
    $config->set('key_id', $name)->save();
  }

}
