<?php

namespace Drupal\config2php\Form;

use Drupal\config\Form\ConfigSingleExportForm;
use Drupal\config2php\Service\Config2PhpHelperTrait;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\service\CachedStorageTrait;
use Drupal\service\EntityTypeManagerTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

@trigger_error('The ' . __NAMESPACE__ . '\Config2PhpFormBase is deprecated in config2php:2.1.4 and is removed from config2php:3.0.0. There is no replacement. See https://www.drupal.org/node/2856615', E_USER_DEPRECATED);

/**
 * Provides a helper to for submitting a form.
 *
 * @deprecated in config2php:2.1.4 and is removed from config2php:3.0.0. There
 *   is no replacement.
 *
 * @see https://www.drupal.org/node/2856615
 *
 * @phpstan-ignore-next-line
 */
abstract class Config2PhpFormBase extends ConfigSingleExportForm {

  use CachedStorageTrait;
  use Config2PhpHelperTrait;
  use EntityTypeManagerTrait;

  /**
   * The beginning of the message about hidden keys.
   *
   * @var string
   */
  const PREFIX = 'Hidden key';

  /**
   * The end of the message about hidden keys.
   *
   * @var string
   */
  const SUFFIX = ': %keys.';

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return parent::create($container)->addConfig2PhpHelper($container);
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'config2php_form';
  }

  /**
   * Handles switching the export textarea.
   *
   * @param array $form
   *   The form.
   * @param string|null $type
   *   The config type.
   * @param string|null $name
   *   The config name.
   *
   * @return array
   *   The form field renderable element.
   */
  protected function update($form, $type, $name) {
    if (
      !empty($type) &&
      $type !== 'system.simple' &&
      ($definition = $this->entityTypeManager()->getDefinition($type)) !== NULL
    ) {
      $name = "{$definition->getConfigPrefix()}.$name";
    }

    $field = $form['export'];

    if (!$this->configStorage()->exists($name)) {
      $field['#value'] = $field['#description'] = NULL;

      return $field;
    }

    $data = $this->configStorage()->read($name);

    $settings = $name === Config2PhpSettingsForm::NAME
      ? $data : $this->configStorage()->read(Config2PhpSettingsForm::NAME);

    if (!empty($settings['exclude'])) {
      $keys = array_intersect(array_keys($data), $settings['exclude']);

      foreach ($settings['exclude'] as $key) {
        unset($data[$key]);
      }
    }

    $field['#value'] = $this->config2PhpHelper()->convert($data);

    $field['#description'] = $this->t('Configuration name: %name', [
      '%name' => $name,
    ]);

    if (!empty($keys)) {
      $suffix = '';
      $arguments = ['%keys' => implode(', ', $keys)];

      if (($url = Url::fromRoute(Config2PhpSettingsForm::NAME))->access()) {
        $suffix = ' (it can be changed @link)';

        $arguments['@link'] = Link::fromTextAndUrl($this->t('here'), $url)
          ->toString();
      }

      $field['#description'] .= '<br />' . $this->formatPlural(
        count($keys),
        static::PREFIX . $suffix . static::SUFFIX,
        static::PREFIX . "s$suffix" . static::SUFFIX,
        $arguments
      );
    }

    return $field;
  }

}
