<?php

namespace Drupal\config2php\Form;

use Drupal\Component\Utility\NestedArray;
use Drupal\config2php\Service\Config2PhpHelper;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for exporting a single configuration file.
 */
class Config2PhpHtmxForm extends Config2PhpFormBase {

  /**
   * {@inheritdoc}
   */
  public function buildForm(
    array $form,
    FormStateInterface $form_state,
    string $config_type = '',
    string $config_name = '',
  ): array {
    $form = parent::buildForm($form, $form_state, $config_type, $config_name);

    $items = array_map(
      fn(string $field): array => [$field, '#attributes', 'data-hx-post'],
      Config2PhpHelper::$fields,
    );

    $parents = ['#attached', 'http_header', 0];
    $key_exists = FALSE;
    $attachment = NestedArray::getValue($form, [...$parents, 0], $key_exists);

    if ($attachment === 'hx-push-url') {
      $items[] = [...$parents, 1];
    }

    $search = '/admin/config/development/configuration/single/export';
    $replace = "$search-to-php";

    foreach ($items as $parents) {
      NestedArray::setValue(
        $form,
        $parents,
        str_replace($search, $replace, NestedArray::getValue($form, $parents)),
      );
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function updateExport(
    $form,
    string $config_type,
    string $config_name,
  ): array {
    return $this->update($form, $config_type, $config_name);
  }

}
