<?php

namespace Drupal\config2php\Service;

use Drupal\service\ServiceTrait;

/**
 * Provides a trait for the helper service.
 */
trait Config2PhpHelperTrait {

  use ServiceTrait;

  /**
   * The service name.
   *
   * @var string
   */
  protected $serviceConfig2PhpHelper = 'config2php.helper';

  /**
   * Sets the helper.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface|null $container
   *   (optional) The service container. Defaults to NULL.
   *
   * @return $this
   */
  protected function addConfig2PhpHelper($container = NULL) {
    return $this->setKnownService($container);
  }

  /**
   * Gets the helper.
   *
   * @return \Drupal\config2php\Service\Config2PhpHelperInterface
   *   The helper.
   */
  protected function config2PhpHelper() {
    return $this->getKnownService();
  }

}
