<?php

namespace Drupal\config2php\Form;

use Drupal\Component\Utility\NestedArray;
use Drupal\config2php\Service\Config2PhpHelperInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for exporting a single configuration file.
 */
class Config2PhpHtmxForm extends Config2PhpForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(
    array $form,
    FormStateInterface $form_state,
    string $config_type = '',
    string $config_name = '',
  ): array {
    $form = parent::buildForm($form, $form_state, $config_type, $config_name);

    $items = array_map(
      fn(string $field): array => [$field, '#attributes', 'data-hx-post'],
      Config2PhpHelperInterface::FIELDS,
    );

    $parents = ['#attached', 'http_header', 0];
    $key_exists = FALSE;

    if (NestedArray::getValue($form, [...$parents, 0], $key_exists) === 'hx-push-url') {
      $items[] = [...$parents, 1];
    }

    $search = '/admin/config/development/configuration/single/export';
    $replace = "$search-to-php";

    foreach ($items as $parents) {
      NestedArray::setValue(
        $form,
        $parents,
        str_replace($search, $replace, NestedArray::getValue($form, $parents)),
      );
    }

    return $form;
  }

}
