<?php

namespace Drupal\config2php\Routing;

use Drupal\config2php\Form\Config2PhpHtmxForm;
use Drupal\config2php\Service\Config2PhpHelperInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class Config2PhpRouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    if (
      version_compare(\Drupal::VERSION, '11.3', '>=') &&
      ($route = $collection->get('config2php.export')) !== NULL
    ) {
      $route->setDefault('_form', Config2PhpHtmxForm::class);

      foreach (Config2PhpHelperInterface::FIELDS as $name) {
        $route->setDefault($name, '');
      }
    }
  }

}
