<?php

namespace Drupal\config2php\Service;

/**
 * Defines the helper service.
 */
class Config2PhpHelper implements Config2PhpHelperInterface {

  /**
   * {@inheritdoc}
   */
  public function convert(array $data): string {
    $data = var_export($data, TRUE);

    $replacement = "(\s+(\'[^\']+\'|\d+)\s\=\>\s)";

    $replacements = [
      '^array \(' => '[',
      '\)$' => ']',
      "$replacement\n\s+array\s\(" => '$1[',
      "\[\n\s+\)" => '[]',
      '\d+\s\=\>\s' => '',
      "{$replacement}false\," => '$1FALSE,',
      "{$replacement}true\," => '$1TRUE,',
    ];

    foreach ($replacements as $pattern => $replacement) {
      $data = preg_replace("/$pattern/", $replacement, $data);
    }

    $count = 0;

    do {
      $data = preg_replace("/(,\n\s+)\),/", '$1],', $data, -1, $count);
    } while ($count);

    return $data;
  }

}
