<?php

namespace Drupal\config2php\Service;

use Drupal\service\ServiceTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a trait for the helper service.
 */
trait Config2PhpHelperTrait {

  use ServiceTrait;

  /**
   * The service name.
   *
   * @var string
   */
  protected const serviceConfig2PhpHelper = 'config2php.helper';

  /**
   * Sets the helper.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface|null $container
   *   (optional) The service container. Defaults to NULL.
   */
  protected function addConfig2PhpHelper(?ContainerInterface $container = NULL): static {
    return $this->setKnownService($container);
  }

  /**
   * Gets the helper.
   */
  protected function config2PhpHelper(): Config2PhpHelperInterface {
    return $this->getKnownService();
  }

}
