<?php

declare(strict_types=1);

namespace Drupal\Tests\config_enforce\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\user\UserInterface;

/**
 * Test that UI elements are displayed for related field storage config.
 *
 * @group config_enforce
 */
class FieldStorageUiTest extends BrowserTestBase {

  use ConfigEnforceUiAssertTestTrait;

  /**
   * The admin user used in this test.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $adminUser;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['config_enforce', 'config_enforce_node_test', 'node', 'field_ui'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer content types',
      'administer node fields',
    ]);
  }

  /**
   * Test that config enforce UI indicator displays for field storage config.
   */
  public function testContentForm(): void {
    $this->drupalLogin($this->adminUser);

    $this->drupalGet('admin/structure/types/manage/page/fields/node.page.field_text_field');

    $this->assertConfigEnforceConfigNameFormExists('field.field.node.page.field_text_field');
    $this->assertConfigEnforceConfigNameFormExists('field.storage.node.field_text_field');
  }

}
