<?php

declare(strict_types=1);

namespace Drupal\config_enforce\Template;

/**
 * Interface defining various Config Enforce element attribute names.
 *
 * These data attributes are added in
 * \Drupal\config_enforce\Element\ConfigEnforceIndicator::preRenderIndicator().
 */
interface ConfigEnforceAttributesInterface {

  /**
   * Name of data attribute added to each config item containing its name.
   */
  public const CONFIG_DATA_ATTR_NAME = 'data-config-enforce-config-name';

  /**
   * Data attribute added to each config item containing its enforcement status.
   */
  public const CONFIG_DATA_ATTR_STATUS = 'data-config-enforce-config-status';

  /**
   * Data attribute added to each config item containing its enforcement level.
   */
  public const CONFIG_DATA_ATTR_ENFORCEMENT_LEVEL =
    'data-config-enforce-config-enforce-level';

}
