<?php

declare(strict_types=1);

namespace Drupal\config_enforce_devel\FormHandler;

use Drupal\config_enforce\FormHandler\AbstractEnforceFormHandler;
use Drupal\config_enforce_devel\FormHandler\ThemeSettingsFormHandlerTrait;
use Drupal\config_enforce_devel\TargetModuleCollection;
use Drupal\Core\Url;

/**
 * Attach an embedded enforce form to a host config form.
 */
class DevelEnforceFormHandler extends AbstractEnforceFormHandler {

  use ThemeSettingsFormHandlerTrait;

  /**
   * Method to call from implementations of hook_alter().
   */
  public function alter() {
    // Only operate on config forms.
    if (!$this->isAnEnforceableForm()) return;

    $this->addOffCanvasLinks();
  }

  /**
   * Embed links in the config form that will open an off-canvas dialog to
   * manage config enforce settings.
   */
  protected function addOffCanvasLinks() {
    foreach ($this->getConfigNames() as $config_name) {
      $this->form()["config_enforce:{$config_name}"] = [
        '#title' => $this->t("Enforce: {$config_name}"),
        '#type' => 'link',
        '#url' => Url::fromRoute('config_enforce_devel.config_edit', [
          'config_name' => $config_name
        ]),
        '#attributes' => [
          'class' => [
            'use-ajax',
            'button',
          ],
          'data-dialog-type' => "dialog",
          'data-dialog-renderer' => "off_canvas",
          'data-dialog-options' => [
            '{"width":400}',
          ],
        ],
        // TODO: In a JavaScript context, consider simply closing the off-canvas
        // dialog rather than redirecting the entire page.
        '#options' => [
          'query' => \Drupal::destination()->getAsArray(),
        ],
        '#attached' => [
          'library' => 'core/drupal.dialog.ajax',
        ],
        '#weight' => -1001,
      ];
    }
  }

}
