<?php

namespace Drupal\config_enforce_devel\Element;

use Drupal\config_enforce\Element\ConfigEnforceIndicator;
use Drupal\Core\Render\Attribute\RenderElement;
use Drupal\Core\Url;

/**
 * Provides a config enforce devel indicator element.
 */
#[RenderElement('config_enforce_devel_indicator')]
class ConfigEnforceDevelIndicator extends ConfigEnforceIndicator {

  /**
   * {@inheritdoc}
   */
  public static function preRenderIndicator($element, $displayUnenforced = TRUE) {
    $element = parent::preRenderIndicator($element, $displayUnenforced);
    $config_name = $element['#config_name'];

    // Add a button to manage enforcement settings.
    $element['indicator']["config_enforce:{$config_name}"] = [
      // TODO: Figure out if there is something else we should do here, in
      // a static context.
      '#title' => t("Manage settings"),
      '#type' => 'link',
      '#url' => Url::fromRoute('config_enforce_devel.config_edit', [
        'config_name' => $config_name,
      ]),
      '#attributes' => [
        'class' => [
          'use-ajax',
          'button',
        ],
        'data-dialog-type' => "dialog",
        'data-dialog-renderer' => "off_canvas",
        'data-dialog-options' => [
          '{"width":400}',
        ],
      ],
      // TODO: In a JavaScript context, consider simply closing the off-canvas
      // dialog rather than redirecting the entire page.
      '#options' => [
        'query' => \Drupal::destination()->getAsArray(),
      ],
      '#attached' => [
        'library' => 'core/drupal.dialog.ajax',
      ],
    ];

    return $element;
  }

}
