<?php

declare(strict_types=1);

namespace Drupal\config_enforce_devel\FormHandler;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element;

/**
 * Swap config_enforce_indicator elements to use config_enforce_devel version.
 */
class DevelEnforceSwapIndicators {

  /**
   * Method to call from implementations of hook_alter().
   */
  public function alter(&$form, FormStateInterface $form_state) {
    // If there are any config_enforce_indicator elements, change each of them
    // to a config_enforce_devel_indicator.
    if (isset($form['config_enforce_container'])) {
      foreach (Element::children($form['config_enforce_container']) as $key) {
        $form['config_enforce_container'][$key]['#type'] = 'config_enforce_devel_indicator';
      }
    }
  }

}
