<?php

declare(strict_types=1);

namespace Drupal\config_enforce_devel;

use Drupal\config_enforce\EnforcedConfig;

/**
 * Defines a trait for functionality related to ignored configuration.
 */
trait IgnoredConfigTrait {

  /**
   * Gets a read-only version of the given config object.
   *
   * @param string $name
   *   The name of the config object to get.
   */
  abstract protected function config($name);

  /**
   * Check if the config object has been ignored.
   */
  protected function isIgnored(string $config_name): bool {
    return in_array($config_name, $this->getIgnoredConfigs());
  }

  /**
   * List ignored config objects.
   */
  protected function getIgnoredConfigs() {
    $ignored_configs = $this->config('config_enforce_devel.settings')->get('ignored_configs');
    return is_null($ignored_configs) ? [] : array_combine($ignored_configs, $ignored_configs);
  }

}
