<?php

declare(strict_types=1);

namespace Drupal\Tests\config_enforce_devel\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\user\UserInterface;

/**
 * Basic tests for the main config enforce form.
 *
 * @group config_enforce_devel
 */
class ConfigEnforceFormTest extends BrowserTestBase {

  /**
   * The admin user used in this test.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $adminUser;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'config_enforce', 'config_enforce_devel', 'config_enforce_test', 'system',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer site configuration',
    ]);
  }

  /**
   * Test the config enforce form.
   *
   * Note that any changes saved here will persist to disk, so changing
   * enforcement settings here can affect other tests.
   *
   * TODO: Consider a more robust approach, like copying the test module to
   * a site-specific directory.
   */
  public function testConfigEnforceForm(): void {
    $config_name = 'system.site';
    $this->drupalLogin($this->adminUser);

    // Check that the config is already enforced by the test module.
    $this->drupalGet('/admin/config/development/config_enforce/enforced_configs');
    $this->assertSession()->pageTextContains($config_name);

    // Unenforce the config.
    $this->drupalGet('/admin/config/development/config_enforce/edit/' . $config_name);
    $this->assertSession()->fieldExists('edit-config-enforce-enabled')->uncheck();
    $this->submitForm([], 'Save');

    // Check that the config is no longer in the list of enforced configs.
    $this->drupalGet('/admin/config/development/config_enforce/enforced_configs');
    $this->assertSession()->pageTextNotContains($config_name);
  }

}
