<?php

namespace Drupal\config_layers\Config;

/**
 * Normalized storage. Sort config arrays by key.
 */
class NormalizedStorage extends StorageDecorator {

  /**
   * The config sorter used to normalize configuration.
   *
   * @var \Drupal\config_layers\Config\ConfigSorter
   */
  protected $configSorter;

  /**
   * Get config sorter.
   *
   * @return Drupal\config_layers\Config\ConfigSorter
   *   Config sorter service.
   */
  protected function getSorter() {
    if (!$this->configSorter) {
      $this->configSorter = \Drupal::service('config_layers.sorter');
    }
    return $this->configSorter;
  }

  /**
   * {@inheritdoc}
   */
  public function read($name) {
    $config = $this->decorated->read($name);
    if (is_array($config)) {
      $config = $this->getSorter()->sort($name, $config);
    }
    return $config;
  }

  /**
   * {@inheritdoc}
   */
  public function readMultiple(array $names) {
    $list = $this->decorated->readMultiple($names);
    foreach ($list as $name => &$data) {
      if (is_array($data)) {
        $data = $this->getSorter()->sort($name, $data);
      }
    }
    return $list;
  }

  /**
   * {@inheritdoc}
   */
  public function createCollection($collection) {
    return new NormalizedStorage($this->decorated->createCollection($collection));
  }

}
