<?php

namespace Drupal\config_translation_sync;

/**
 * Defines the interface for services that sync configuration translations.
 */
interface ConfigTranslationSyncerInterface {

  /**
   * Synchronize translations for configuration items.
   *
   * @param string[] $include_patterns
   *   Config names or patterns to include. If empty, all configs are included.
   * @param string[] $exclude_patterns
   *   Config names or patterns to exclude. If empty, use excluded from config.
   * @param string|null $langcode
   *   Optional language code(s). If NULL, use enabled languages from config.
   */
  public function sync(array $include_patterns = [], array $exclude_patterns = [], ?string $langcode = NULL): void;

}
