# Config Translation Sync

**Config Translation Sync** provides automated synchronization of configuration translations across environments.  
It extends the core **Config Translation** module by ensuring that multilingual configuration remains consistent after imports, deployments, or updates.

---

## Features

- Synchronizes translated configuration from the sync directory into the active configuration.
- Supports **include** and **exclude** patterns for fine‑grained control.
- Respects enabled languages or allows restricting to specific language codes.
- Provides a **Drush command** (`drush crst`) for quick resynchronization in CI/CD pipelines or local development.
- Logs changes for transparency and debugging.

---

## Requirements

- Drupal core `config_translation` module must be enabled.

---

## Usage
Run the Drush command to resynchronize configuration translations:
`drush crst`

### Options
- `--config-names`
Comma‑separated list of config names or patterns to resync.

Example:
`drush crst --config-names=system.*`

- `--exclude`
Comma‑separated list of configs or patterns to exclude.

Example:
`drush crst --config-names=views.view.* --exclude=views.view.frontpage`

- `--langcode`
Restrict sync to a specific language (or multiple, comma‑separated).

Example:
`drush crst --config-names=system.* --langcode=ru,en`

---

## Maintainer
Alexander Shabanov (fromme) - https://www.drupal.org/u/fromme