<?php

namespace Drupal\config_translation_sync\EventSubscriber;

use Drupal\config_translation_sync\ConfigTranslationSyncerInterface;
use Drupal\Core\Config\ConfigEvents;
use Drupal\Core\Config\ConfigImporterEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to config import events to trigger translation sync.
 */
class ConfigImportSubscriber implements EventSubscriberInterface {

  /**
   * The config translation syncer service.
   */
  protected ConfigTranslationSyncerInterface $syncer;

  /**
   * Constructs the subscriber.
   *
   * @param \Drupal\config_translation_sync\ConfigTranslationSyncerInterface $syncer
   *   The config translation syncer service.
   */
  public function __construct(ConfigTranslationSyncerInterface $syncer) {
    $this->syncer = $syncer;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      ConfigEvents::IMPORT => 'onPostImport',
    ];
  }

  /**
   * Reacts after config import is finished.
   *
   * @param \Drupal\Core\Config\ConfigImporterEvent $event
   *   The config importer event.
   */
  public function onPostImport(ConfigImporterEvent $event): void {
    $changed = array_merge(
      $event->getChangelist('update'),
      $event->getChangelist('create')
    );

    if (!empty($changed)) {
      $this->syncer->sync($changed);
    }
  }

}
