<?php

namespace Drupal\Tests\config_translation_sync\Unit;

use Drupal\config_translation_sync\ConfigTranslationSyncerInterface;
use Drupal\config_translation_sync\Drush\Commands\ConfigTranslationSyncCommands;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\config_translation_sync\Drush\Commands\ConfigTranslationSyncCommands
 *
 * @group config_translation_sync
 */
class ConfigTranslationSyncCommandsTest extends TestCase {

  /**
   * Mock syncer service.
   */
  protected ConfigTranslationSyncerInterface|MockObject $syncer;

  /**
   * Command under test.
   */
  protected ConfigTranslationSyncCommands $command;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->syncer = $this->createMock(ConfigTranslationSyncerInterface::class);
    $this->command = new ConfigTranslationSyncCommands($this->syncer);
  }

  /**
   * Provides scenarios for resyncTranslations().
   *
   * @return array[]
   *   Test cases.
   */
  public static function providerResync(): array {
    return [
      'explicit configs via option' => [
        ['config-names' => 'system.site,views.view.frontpage', 'langcode' => 'ru', 'exclude' => NULL],
    // Expected include.
        ['system.site', 'views.view.frontpage'],
    // Expected exclude.
        [],
        'ru',
      ],
      'all configs with exclude' => [
        ['config-names' => NULL, 'langcode' => NULL, 'exclude' => 'system.site,views.view.frontpage'],
      // Expected include.
        [],
      // Expected exclude.
        ['system.site', 'views.view.frontpage'],
        NULL,
      ],
      'all configs without exclude' => [
        ['config-names' => NULL, 'langcode' => NULL, 'exclude' => NULL],
      // Expected include.
        [],
      // Expected exclude.
        [],
        NULL,
      ],
    ];
  }

  /**
   * Tests resyncTranslations() with different scenarios.
   *
   * @dataProvider providerResync
   */
  public function testResyncTranslations(
    array $options,
    array $expectedInclude,
    array $expectedExclude,
    ?string $expectedLangcode,
  ): void {
    $this->syncer->expects($this->once())
      ->method('sync')
      ->with($expectedInclude, $expectedExclude, $expectedLangcode);

    $this->command->resyncTranslations($options);
  }

}
