Provides deterministic UUIDs for exported configuration. Instead of random UUIDs, this module generates predictable UUID v5 hashes based on the configuration name and a fixed namespace. This ensures stable and repeatable `config:export` results, making clean installs and generated configuration (such as through migrations) consistent across environments.

### **Features**

* Generates deterministic UUIDs using UUID v5 specification for all exported configuration.  
* UUID hash is derived from the config name and a configurable namespace UUID.  
* Ensures exports of the same config file always produce the same UUID.  
* Handles nested plugin instances within configuration (e.g., image effects, filters) with hierarchical UUID generation.  
* Intelligently skips UUID remapping for field storage configs with long names that would break Drupal's hashed table name resolution.  
* Overrides both file storage (for exports) and active database storage (for runtime consistency).  
* Integrates seamlessly with `drush config:export` and core configuration management.  
* Improves reproducibility and version control cleanliness by eliminating UUID churn.  
* Supports complex nested configuration structures with deterministic UUID generation at all levels.

### **Post-Installation**

No configuration required. Once enabled, `drush config:export` or core export functionality will automatically use deterministic UUIDs. For example, `admin_toolbar.settings.yml` will always export with  
 the same UUID. The module uses a default namespace UUID (00000000-0000-0000-0000-000000000000) which can be customized by modifying the NAMESPACE constant in the module's classes for project-specific implementations.

### **Technical Details**

The module implements custom storage classes that extend Drupal's FileStorage and DatabaseStorage, intercepting read and write operations to ensure UUID consistency. It uses the Ramsey UUID library to generate UUID v5 hashes, ensuring compliance with RFC 4122\. The module also includes intelligent detection for field storage configurations that would be affected by Drupal's table name hashing mechanism, preserving their original UUIDs to maintain database integrity.

### **Additional Requirements**

Requires the Ramsey UUID library (automatically managed via Composer). Works with Drupal core configuration management system (Drupal 9 or 10).

### **Recommended modules/libraries**

Optional but useful with migration and config management workflows:

* [Config Split](https://www.drupal.org/project/config_split) \- For environment-specific configuration management  
* [Config Filter](https://www.drupal.org/project/config_filter) \- For advanced configuration filtering  
* [Config Ignore](https://www.drupal.org/project/config_ignore) \- To exclude specific configs from synchronization

### **Similar projects**

Modules like [Config Normalizer](https://www.drupal.org/project/config_normalizer) or href="[https://www.drupal.org/project/config\_sync\_without\_site\_uuid](https://www.drupal.org/project/config_sync_without_site_uuid)"\>Config Sync Without Site UUID handle  
 different aspects of configuration consistency. This module is unique in providing deterministic UUID generation  
 for exported config, including support for nested plugin instances and intelligent field storage handling.

### **Supporting this Module**

If you find this module helpful, consider sponsoring or contributing back via the issue queue.

### **Community Documentation**

Examples, walkthroughs, and use cases will be shared here.

