<?php

namespace Drupal\config_uuid_deterministic\Config;

use Drupal\Core\Config\ConfigDirectoryNotDefinedException;
use Drupal\Core\Site\Settings;

/**
 * Factory for creating our deterministic FileStorage.
 */
class ConfigSyncStorageFactory {

  public static function getSync() {
    $directory = Settings::get('config_sync_directory', FALSE);
    if ($directory === FALSE) {
      throw new ConfigDirectoryNotDefinedException('The config sync directory is not defined.');
    }
    return new FileStorageDeterministic($directory);
  }

}
