<?php

namespace Drupal\config_uuid_deterministic;

use Drupal\config_uuid_deterministic\Config\ConfigSyncStorageFactory;
use Drupal\Core\Config\FileStorageFactory;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Alters the config.storage.sync factory to use our deterministic storage.
 */
class ConfigUuidDeterministicServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $service_name = 'config.storage.sync';
    if ($container->hasDefinition($service_name)) {
      $definition = $container->getDefinition($service_name);
      // Only swap out the default factory.
      if ($definition->getFactory() === [FileStorageFactory::class, 'getSync']) {
        $definition->setFactory([ConfigSyncStorageFactory::class, 'getSync']);
      }
    }
  }

}
