<?php

namespace Drupal\config_uuid_deterministic\Uuid;

use Drupal\Component\Uuid\UuidInterface;
use Ramsey\Uuid\Uuid;

/**
 * Overrides the uuid service to always use V5(namespace, name).
 */
class DeterministicUuid implements UuidInterface {

  /** @var string */
  protected $namespace;

  public function __construct(string $namespace) {
    $this->namespace = $namespace;
  }

  /** {@inheritdoc} */
  public function generate(): string {
    // constant across calls—if you want per-entity,
    // use generateFromName() directly in your code.
    return Uuid::uuid5($this->namespace, $this->namespace)->toString();
  }

  /**
   * Deterministic UUIDv5 based on a stable name.
   */
  public function generateFromName(string $name): string {
    return Uuid::uuid5($this->namespace, $name)->toString();
  }

  /** {@inheritdoc} */
  public function isValid($uuid): bool {
    return Uuid::isValid($uuid);
  }

}
