<?php

namespace Drupal\config_uuid_deterministic\Config;

use Drupal\Core\Config\FileStorage;
use Ramsey\Uuid\Uuid;

/**
 * FileStorage that makes UUIDs deterministic (UUIDv5) on read & write.
 */
class FileStorageDeterministic extends FileStorage {

  use FieldTableNameChecker;

  /**
   * A fixed namespace UUID for your project.
   *
   * Replace with your own stable, valid UUID.
   */
  private const NAMESPACE = '00000000-0000-0000-0000-000000000000';

  /**
   * {@inheritdoc}
   *
   * On read (config:export), rewrite the top-level uuid.
   */
  public function read($name) {
    $data = parent::read($name);
    if ($data && !$this->shouldSkipUuidRemapping($name, $data)) {
      if (isset($data['uuid'])) {
        $data['uuid'] = Uuid::uuid5(self::NAMESPACE, $name)->toString();
      }
      $data = ConfigUuidRemapper::remapNested($data, $name);
    }
    return $data;
  }

  /**
   * {@inheritdoc}
   *
   * On write (config:export & manual saves), rewrite the top-level uuid.
   */
  public function write($name, array $data) {
    if (!$this->shouldSkipUuidRemapping($name, $data)) {
      if (isset($data['uuid'])) {
        $data['uuid'] = Uuid::uuid5(self::NAMESPACE, $name)->toString();
      }
      $data = ConfigUuidRemapper::remapNested($data, $name);
    }
    return parent::write($name, $data);
  }

}
