## Introduction

The Config Warning module provides a visual warning message on key administrative forms that modify site configuration. It is designed to help teams avoid unintentional changes, particularly in production environments, by displaying a configurable message when specific config-related forms are accessed.

The primary use case for this module is:

- Preventing unintended configuration changes on production.
- Educating new developers or site editors about the risks of direct config editing.
- Adding a layer of caution before modifying Views, content types, or other system settings.

## Requirements

- Drupal core (10.x or 11.x)

## Installation

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.
- Via Composer:

  ```bash
  composer require drupal/config_warning
  drush en config_warning -y
  drush cr
  ```

## Configuration

Navigate to:

**Administration → Configuration → Development → Config Warning**

### Steps:

1. **Enable or disable** the warning globally.
2. **Enter** the custom message text to be shown.
3. Click **Save configuration** and the message will now be displayed on the relevant forms.

## Plugin Support Is Currently Limited

Support for additional condition plugins is currently limited to a hardcoded list. This may be made dynamic in the future.

## Maintainers

Current maintainers:

- Rachel Lawson (rachel_norfolk) - https://www.drupal.org/u/rachel_norfolk

