<?php

declare(strict_types=1);

namespace Drupal\configurable_anonymizer;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;

/**
 * Interface for field_anonymizer plugins.
 */
interface FieldAnonymizerInterface {

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  public function supportsField(FieldDefinitionInterface $field): bool;

  public function anonymize(FieldItemListInterface $field): void;
}
