<?php

declare(strict_types=1);

namespace Drupal\configurable_anonymizer;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for field_anonymizer plugins.
 */
abstract class FieldAnonymizerPluginBase extends PluginBase implements FieldAnonymizerInterface {

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

}
