<?php

declare(strict_types=1);

namespace Drupal\configurable_anonymizer;

use Drupal\configurable_anonymizer\Attribute\FieldAnonymizer;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;

/**
 * FieldAnonymizer plugin manager.
 */
final class FieldAnonymizerPluginManager extends DefaultPluginManager {

  use StringTranslationTrait;

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler, TranslationInterface $string_translation) {
    parent::__construct('Plugin/FieldAnonymizer', $namespaces, $module_handler, FieldAnonymizerInterface::class, FieldAnonymizer::class);
    $this->alterInfo('field_anonymizer_info');
    $this->setCacheBackend($cache_backend, 'field_anonymizer_plugins');
    $this->stringTranslation = $string_translation;
  }


  public function getPluginOptionsForField(FieldDefinitionInterface $field): array {
    $options = ['' => $this->t('Do not anonymize')];
    foreach ($this->getDefinitions() as $plugin_id => $definition) {
      $instance = $this->createInstance($plugin_id);
      if ($instance->supportsField($field)) {
        $options[$plugin_id] = $definition['label'];
      }
    }

    return $options;
  }

}
