<?php

namespace Drupal\configurable_anonymizer\Drush\Commands;

use Drupal\configurable_anonymizer\Service\AnonymizerService;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

/**
 * A Drush commandfile.
 */
final class ConfigurableAnonymizerDrushCommands extends DrushCommands {

  use AutowireTrait;

  /**
   * Constructs a ConfigurableAnonymizerCommands object.
   */
  public function __construct(
    #[Autowire('configurable_anonymizer.service')]
    private readonly AnonymizerService $configurableAnonymizerService,
  ) {
    parent::__construct();
  }

  /**
   * Command description here.
   */
  #[CLI\Command(name: 'anonymizer:run', aliases: ['anon-run'])]
  #[CLI\Usage(name: 'anonymizer:run', description: 'Anonymizes data of the configured fields')]
  #[CLI\Help(description: 'Anonymizes data of the configured fields')]
  public function run(): int {
    $this->configurableAnonymizerService->anonymize();
    drush_backend_batch_process();
    return 0;
  }

}
