<?php

namespace Drupal\configurable_anonymizer\Hook;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\Query\QueryInterface;
use Drupal\Core\Hook\Attribute\Hook;

class EntityQueryAlter {

    public function __construct(protected EntityTypeManagerInterface $entityTypeManager) {
    }

    #[Hook('entity_query_tag__user__configurable_anonymizer_alter')]
    public function entityQueryAlter(QueryInterface $query) {
        $query->condition($this->entityTypeManager->getDefinition('user')->getKey('id'), 1, '>');
    }
}
