<?php

declare(strict_types=1);

namespace Drupal\configurable_anonymizer\Plugin\FieldAnonymizer;

use Drupal\configurable_anonymizer\Attribute\FieldAnonymizer;
use Drupal\configurable_anonymizer\FieldAnonymizerPluginBase;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Override;

/**
 * Plugin implementation of the field_anonymizer.
 */
#[FieldAnonymizer(
  id: 'default',
  label: new TranslatableMarkup('Default field anonymizer'),
  description: new TranslatableMarkup("Uses Drupal core's FieldItemInterface::generateSampleValue to generate the anonymized values."),
)]
class DefaultFieldAnonymizer extends FieldAnonymizerPluginBase {

  #[Override]
  public function supportsField(FieldDefinitionInterface $field): bool {
    return TRUE;
  }

  #[\Override]
  public function anonymize(FieldItemListInterface $field): void {
    if ($field->isEmpty()) {
      return;
    }
    $field->generateSampleItems($field->count());
  }
}
