<?php

namespace Drupal\configurable_anonymizer_oidc\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Database\Query\AlterableInterface;
use Drupal\Core\Database\Query\SelectInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

class QueryAlter {

  protected ImmutableConfig $config;

  public function __construct(
    #[Autowire(service: 'config.factory')]
    ConfigFactoryInterface $configFactory
  ) {
    $this->config = $configFactory->get('configurable_anonymizer_oidc.settings');
  }

  #[Hook('query_configurable_anonymizer_alter')]
  public function queryAlter(AlterableInterface $query) {
    if (!$query instanceof SelectInterface) {
      return;
    }
    if ($query->getMetaData('entity_type') !== 'user') {
      return;
    }
    $disabled_realms = $this->config->get('disabled_realms');
    if (!$disabled_realms) {
      return;
    }

    $authmap_alias = $query->leftJoin('authmap', 'a', '%alias.uid = base_table.uid');
    $query->condition($authmap_alias . '.provider', array_map(fn ($value) => 'oidc:' . $value, $disabled_realms), 'NOT IN');
  }
}
