(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.confirmUnpublish = {
    attach(context) {
      if (context !== document) return;

      const $checkbox = $('input[name="status[value]"]', context);
      let wasChecked = $checkbox.prop('checked');

      $checkbox.on('change', function () {
        const isNowChecked = $(this).prop('checked');

        if (wasChecked && !isNowChecked) {
          $('<div></div>')
            .html(drupalSettings.confirm_unpublish.message)
            .dialog({
              modal: true,
              title: Drupal.t('Confirm Unpublish'),
              width: '50%',
              buttons: {
                Cancel() {
                  $checkbox.prop('checked', true);
                  $(this).dialog('close');
                },
                Confirm() {
                  wasChecked = false;
                  $(this).dialog('close');

                  if (drupalSettings.confirm_unpublish.logging) {
                    $.post(Drupal.url('confirm-unpublish/log'), {
                      uid: drupalSettings.confirm_unpublish.user_id,
                      nid: drupalSettings.confirm_unpublish.node_id,
                    });
                  }
                },
              },
            });
        } else {
          wasChecked = isNowChecked;
        }
      });
    },
  };
})(jQuery, Drupal, drupalSettings);
