<?php

namespace Drupal\connectid_login\Plugin\OpenIDConnectClient;

use ConnectID\Api\DataModel\ConnectIdProfile;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openid_connect\Annotation\OpenIDConnectClient;
use Drupal\openid_connect\Plugin\OpenIDConnectClientBase;
use Ramsalt\OAuth2\Client\Provider\Endpoints;

/**
 *
 * @OpenIDConnectClient(
 *   id = "connectid",
 *   label = @Translation("ConnectID (MediaConnect)")
 * )
 */
class ConnectId extends OpenIDConnectClientBase {

  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    $form['testing'] = [
      '#title' => $this->t('Use testing endpoint'),
      '#type' => 'checkbox',
      '#default_value' => $this->configuration['testing'],
    ];


    return $form;
  }


  public function getEndpoints() {
    $testing = $this->configuration['testing'] ?? FALSE;
    return [
      'authorization' => Endpoints::getBaseAuthorizationUrl($testing),
      'token'         => Endpoints::getBaseAccessTokenUrl($testing),
      'userinfo'      => Endpoints::getResourceOwnerDetailsUrl($testing),
    ];
  }

  public function authorize($scope = 'openid email') {
    $scopes = $this->configuration['scopes'] ?? [];
    return parent::authorize('');
  }


  public function decodeIdToken($id_token) {
    return [];
  }


  public function retrieveUserInfo($access_token) {
    $data = parent::retrieveUserInfo($access_token);
    if (empty($data)) {
      return $data;
    }
    $profile = ConnectIdProfile::createFromApiResponse($data);
    return [
      'sub'   => $profile->getUniqueId(),
      'email' => $profile->getEmailDefault(),
      // Include the RAW response data/
      '_raw'  => $data,
    ];
  }


  public function retrieveTokens($authorization_code) {
    return parent::retrieveTokens($authorization_code);
  }


}
