<?php

namespace Drupal\consent_management\Batch;

use Drupal\user\UserInterface;
use Drupal\Core\Entity\EntityInterface;


class DataPolicyMigrationBatch {

  public static function finished($success, $results, $operations) {
    \Drupal::messenger()->addMessage(t('Successfully migrated @results data policies!', ['@results' => $results['processed']]));
  }

  public static function operation($data_policy, &$context) {    

    $cm_policy_storage = \Drupal::entityTypeManager()->getStorage('cm_policy');
    $cm_policy_version_storage = \Drupal::entityTypeManager()->getStorage('cm_policy_version');

    if (!array_key_exists('processed', $context['results'])) {
      $context['results']['processed'] = 0;
    }

    $context['results']['processed']++;    
  
    // Now we have to create the policy
    $policy_data = [
      'label' => $data_policy->label(),
      'policy_required' => TRUE,
      'status' => TRUE,
      'source_id' => $data_policy->id(),
      'created' => $data_policy->created->value,
      'changed' => $data_policy->changed->value,      
    ];

    // Create data
    $policy_id = \Drupal::service('consent_management.migration')->createPolicy($policy_data);

    if ($policy_id) {
      // Now we have to create the version
      $related_revisions = \Drupal::service('consent_management.migration')->getAllRelatedRevisions('data_policy', $data_policy);
      $current_revision = \Drupal::service('consent_management.migration')->getCurrentRevision('data_policy', $data_policy);

      foreach ($related_revisions as $revision) {

        $policy_version_data = [
          'label' => $revision->label(),
          'policy_text' => [
            'value' => $revision->field_description->value,
            'format' => $revision->field_description->format,
          ],
          'source_id' => $revision->vid,
          'cm_policy' => $policy_id,
          'created' => $revision->getRevisionCreationTime(),
          'changed' => $revision->getRevisionCreationTime(),
          'uid' => $data_policy->getRevisionUserId(),
        ];

        $policy_version_id = \Drupal::service('consent_management.migration')->createPolicyVersion($policy_version_data);

        if ($policy_version_id) {
          // We need to know the current revision
          if ($current_revision == $data_policy->getRevisionId()) {
            // We need to set the cm_policy_version reference to the cm_policy_version id
            $policy = \Drupal::service('consent_management.migration')->loadPolicy($policy_id);
            if ($policy instanceof EntityInterface) {
              $policy->setPolicyVersionId($policy_version_id);
              $policy->save();
            }
          }
        } 

  
        //\Drupal::logger('consent_management')->notice('<pre>'.print_r($policy_version_data, TRUE).'</pre>');
  
  
  
      }





    }


    \Drupal::logger('consent_management')->notice('<pre>'.print_r($policy_data, TRUE).'</pre>');




    
  
  } 


}
