<?php

namespace Drupal\consent_management\Batch;

use Drupal\user\UserInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Component\Utility\Html;



class MigrationUserConsentBatch {

  public static function finished($success, $results, $operations) {
    \Drupal::messenger()->addMessage(t('Successfully updated @results user consent records!', ['@results' =>  count($results)]));
  }

  public static function operation(&$context) {

    // Get amount of all user consent records
    $max_records = \Drupal::service('consent_management.migration')->amountOfRecordsMigrateUserConsent();

    if (!isset($context['sandbox']['progress'])) {
      $context['sandbox']['progress'] = 0;
      $context['sandbox']['current_consent'] = 0;
      $context['sandbox']['max'] = $max_records;
    }    


    // We can safely process 10 records at one time.
    $limit = 100;

    $result = \Drupal::service('consent_management.migration')->getMigrateUserConsentRange($context['sandbox']['progress'], $limit);

    foreach ($result as $record) {
      // Get the columns for the record
      $user_consent_id = $record->id;
      $uuid = $record->uuid;
      $langcode = $record->langcode;
      $user_id = $record->user_id;
      $state = $record->state;
      $status = $record->status;
      $created = $record->created;
      $changed = $record->changed;
      $revision_id = $record->revision_id;

        
      // Now we need to know what policy version id is available for our revision_id
      $policy_version = \Drupal::service('consent_management.migration')->getPolicyVersionIdBySourceId($revision_id);
      if ($policy_version instanceof EntityInterface) {
        $policy_version = $policy_version->id();
      }
      else {
        // Take the record and set it to 0 to mark an error!
        $policy_version = 0;
      }      

      $cm_user_consent = [
        'uid' => $user_id,
        'cm_policy_version' => $policy_version,
        'created' => $created,
        'changed' => $changed,
        'langcode' => $langcode,
        'state' => $state,
        'status' => $status,
        'meta_user_id' => $user_id,
        'original_id' => $revision_id,
      ];


      \Drupal::service('consent_management.migration')->createUserConsent($cm_user_consent);

      $context['results'][] = Html::escape($user_consent_id);

      // Update progress information.
      $context['sandbox']['progress']++;
      $context['sandbox']['current_consent'] = $user_consent_id;
      $context['message'] = t('Now processing user consent with ID: @record', ['@record' => $user_consent_id]);      
      
      // Inform the batch engine that we are not finished,
      // and provide an estimation of the completion level we reached.
      if ($context['sandbox']['progress'] != $context['sandbox']['max']) {
        $context['finished'] = $context['sandbox']['progress'] / $context['sandbox']['max'];
      }        
    }  
  } 
}
