<?php

namespace Drupal\consent_management\Batch;

use Drupal\user\UserInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Component\Utility\Html;


class UserConsentMigrationBatch {

  public static function finished($success, $results, $operations) {
    \Drupal::messenger()->addMessage(t('Successfully migrated @results user consent records!', ['@results' =>  count($results)]));
  }

  public static function operation(&$context) {

    // Get amount of all user consent records
    $max_records = \Drupal::service('consent_management.migration')->amountOfRecordsUserConsent();

    if (!isset($context['sandbox']['progress'])) {
      $context['sandbox']['progress'] = 0;
      $context['sandbox']['current_consent'] = 0;
      $context['sandbox']['max'] = $max_records;
    }    


    // We can safely process 10 records at one time.
    $limit = 100;

    $result = \Drupal::service('consent_management.migration')->getUserConsentRange($context['sandbox']['progress'], $limit);

    foreach ($result as $record) {
      $user_consent = \Drupal::service('consent_management.migration')->loadUserConsent($record);
      if ($user_consent instanceof EntityInterface) {
        // Get the revision id 
        $revision_id = $user_consent->data_policy_revision_id->value;    
        // Now we need to get our version id instead
        
        $policy_version = \Drupal::service('consent_management.migration')->getPolicyVersionIdBySourceId($revision_id);

        if ($policy_version instanceof EntityInterface) {

          $cm_user_consent = [
            'uid' => $user_consent->getOwnerId(),
            'cm_policy_version' => $policy_version->id(),
            'created' => $user_consent->created->value,
            'changed' => $user_consent->changed->value,
            'langcode' => $user_consent->language()->getId(),
            'state' => $user_consent->state->value,
            'status' => $user_consent->status->value,
            'meta_user_id' => $user_consent->getOwnerId(),
          ];

          // Get the user
          /*
          $data_consent_user = \Drupal::service('consent_management.migration')->getUser($user_consent->getOwnerId());
          if ($data_consent_user instanceof UserInterface) {
            $cm_user_consent['meta_user_name'] = $data_consent_user->getUsername();
            $cm_user_consent['meta_user_mail'] = $data_consent_user->getEmail();
            $cm_user_consent['meta_user_created'] = $data_consent_user->getCreatedTime();
          }     
          */   
  
          \Drupal::service('consent_management.migration')->createUserConsent($cm_user_consent);

          $context['results'][] = Html::escape($user_consent->id());

          // Update progress information.
          $context['sandbox']['progress']++;
          $context['sandbox']['current_consent'] = $user_consent->id();
          $context['message'] = t('Now processing user consent with ID: @record', ['@record' => $user_consent->id()]);

          // Inform the batch engine that we are not finished,
          // and provide an estimation of the completion level we reached.
          if ($context['sandbox']['progress'] != $context['sandbox']['max']) {
            $context['finished'] = $context['sandbox']['progress'] / $context['sandbox']['max'];
          }
          
        }
        else {
          \Drupal::logger('consent_management')->warning('There is not correct policy version mapping. Please check your versions!');
        }   
      }
    }  
  } 
}
