<?php

namespace Drupal\consent_management\Batch;

use Drupal\user\UserInterface;


class UsersConsentPolicyVersionBatch {

  public static function finished($success, $results, $operations) {
    \Drupal::messenger()->addMessage('Successfully finished for all users!');
  }

  public static function processUser($policy_version_id, $uid, &$context) {

    $user = \Drupal::entityTypeManager()->getStorage('user')->load($uid);

    if (!$user instanceof UserInterface) {
      return;
    }

    if (!array_key_exists('processed', $context['results'])) {
      $context['results']['processed'] = 0;
    }

    $context['results']['processed']++;    
  
    // First of all check if the policy version exists in the user consent for that user
    if (\Drupal::service('consent_management.helper')->policyVersionExists($policy_version_id, $uid)) {
      
      $context['message'] = t('Processing %user', ['%user' => $user->name]);      
      
      // Create user consent record.
      \Drupal::service('consent_management.helper')
        ->createPolicyVersionForUserConsent($policy_version_id, $uid);    

    }
  
  } 


}
