<?php

declare(strict_types=1);

namespace Drupal\consent_management\Commands;

use Drupal\consent_management\Migration;
use Drupal\Core\Batch\BatchBuilder;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drush\Commands\DrushCommands;
use Drupal\consent_management\Batch\UserConsentMigrationBatch;
use Drupal\consent_management\Batch\MigrationUserConsentBatch;
use Drupal\consent_management\Batch\MigrationRemoveOldRecordsBatch;
use Drupal\Core\Logger\LoggerChannelTrait;


/**
 * @todo Add class description.
 */
final class BatchCommands extends DrushCommands {

  use StringTranslationTrait;
  use LoggerChannelTrait;

  /**
   * Constructs a BatchCommands object.
   */
  public function __construct(
    private readonly Migration $migrationService,
  ) {}

  /**
   * Run a batch operation via a drush command to migrate user consent from data policy module.
   *
   * @command consent-management:migrate-user-consent
   * @aliases comuc, migrate-user-consent
   *
   * @validate-module-enabled consent_management
   *
   * @usage consent-management:migrate-user-consent
   */
  public function runConsentManagementMigrateUserConsent() {

    $user_consents = $this->migrationService->userConsentPresent();
    if (!$user_consents) {
      $batch = new BatchBuilder();
      $batch->setTitle('Running migration.')
        ->setFinishCallback([UserConsentMigrationBatch::class, 'finished'])
        ->addOperation([UserConsentMigrationBatch::class, 'operation'],[])
        ->setInitMessage('Commencing')
        ->setProgressMessage('Processing...')
        ->setErrorMessage('An error occurred during processing.'); 
     
      batch_set($batch->toArray());

      if (\Drupal::service('module_handler')->moduleExists('drush_batch_progressbar')) {
        drush_backend_batch_process('batch-progressbar-process');
      }
      else {
        drush_backend_batch_process();
      } 
      

      // Finish.
      $this->getLogger('consent_management')->info('User Consent Batch operations end.');
    
    }
    else {
      $this->getLogger('consent_management')->info('No data to process. Already migrated?'); 
    }

  }

  /**
   * Run a batch operation via a drush command to migrate user consent from data policy module.
   *
   * @command consent-management:migration-update
   * @aliases commiup, migration-update
   *
   * @validate-module-enabled consent_management
   *
   * @usage consent-management:migration-update
   */
  public function runCmConsentManagementUserConsentAdjustment() {

    $batch = new BatchBuilder();
    $batch->setTitle('Running migration.')
      ->setFinishCallback([MigrationUserConsentBatch::class, 'finished'])
      ->addOperation([MigrationUserConsentBatch::class, 'operation'],[])
      ->setInitMessage('Commencing')
      ->setProgressMessage('Processing...')
      ->setErrorMessage('An error occurred during processing.'); 
     
    batch_set($batch->toArray());

    if (\Drupal::service('module_handler')->moduleExists('drush_batch_progressbar')) {
      drush_backend_batch_process('batch-progressbar-process');
    }
    else {
      drush_backend_batch_process();
    }       

    // Finish.
    $this->getLogger('consent_management')->info('User Consent Batch operations end.'); 

  }  

}



